# Цикл `while`
Разблокирован цикл `while` и значения `True` и `False`. Цикл `while` выполняет тело цикла без остановки, пока условие равно `True`.

`while condition:
	#тело цикла`

Не бойся создать бесконечные циклы. Задержки в выполнении предотвратят зависание программы.

## Для начинающих
Возможно, тебе уже довелось добавить несколько вызовов `harvest()` подряд:

`harvest()
harvest()
harvest()`

Это позволяет собрать урожай несколько раз за один запуск программы.
Однако было бы неплохо собирать урожай более трех раз, а писать многократно один и тот же код не принято.
Решением станет цикл. 
Цикл позволяет выполнять один и тот же код многократно.

Цикл `while` принимает условие, которое является логическим значением и может находиться в одном из двух состояний: `True` или `False`.
Такое значение называется логическим, или булевым.

Затем цикл выполняет код внутри него до тех пор, пока условие не станет `False`.
Цикл `while` выглядит так:

`while condition:
	#тело цикла
	#тело цикла
	#...`
	
Здесь `condition` нужно заменить на логическое значение, а `#тело цикла` на то, что должно происходить в цикле.

Доступны два постоянных логических значения. Константы — это значения, которые не меняются во время выполнения программы.

Чтобы создать постоянное логическое значение, которое всегда `True`, достаточно просто написать `True`. Указывай `False` для постоянного логического значения, которое всегда будет `False`.
Таким образом, можно написать либо


`while False:
	do_a_flip()`

либо

`while True:
	do_a_flip()`

В первом случае дрон никогда не делает сальто, во втором — будет делать его вечно (бесконечный цикл).

Обычно создавать бесконечные циклы не рекомендуется, потому что они приводят к зависанию программы. Однако в игре между каждой итерацией цикла есть задержки, поэтому дрон будет продолжать делать сальто, пока ты не остановишь его вручную, снова нажав кнопку выполнения.

Обрати внимание, что строка после двоеточия имеет отступ. Такие отступы используются для разделения блоков кода.
Нажми Tab, чтобы добавить отступ, или Shift + Tab (или Backspace) — чтобы его убрать.

Цикл будет повторять все инструкции с отступом после двоеточия.
Инструкции после блока с отступом будут выполнены по завершении цикла.
